/* ...............................................................

	WindowColors
	Copyright 1997-8 Steve Klingsporn <moofie@pobox.com>
	Based on WindowShade by Marco Nelissen <marcone@xs4all.nl>
	
		File:	ColorPicker.cpp
	
	Contains:	Implementation of a pickier color picker that
				"live updates" its app-specific hard-coded
				target, and allows you to right-drag out
				color messages in 8-bit mode.
	
	   Notes:	None.
	   
   ............................................................... */

#ifndef _COLOR_PICKER_H
#include "ColorPicker.h"
#endif

/* ...............................................................
	ColorControlFilter Constructor
	Sets the view flags to B_WILL_DRAW only because we don't
	want to steal the keyboard focus.
   ............................................................... */

ColorPicker::ColorPicker(BPoint start)
				 :BColorControl(start, B_CELLS_32x8, 12, "")
{
	SetFlags(B_WILL_DRAW);
}


/* ...............................................................
	ColorPicker::AttachedToWindow()
	Hides them pesky focus-stealing text fields that are normally
	displayed in a BColorControl.		
   ............................................................... */

void ColorPicker::AttachedToWindow()
{
	BColorControl::AttachedToWindow();
	for (uint8 index = 0; index < 3; index++)
		ChildAt(index)->Hide();
}


/* ...............................................................
	ColorPicker::MouseDown()
	Overridden to support right-dragging out a color message in
	8-bit mode.
   ............................................................... */

void ColorPicker::MouseDown(BPoint where)
{
	uint32	buttons;
	GetMouse(&where, &buttons);
	
	/* If the second mouse button is down... */
	if (buttons & B_SECONDARY_MOUSE_BUTTON)
	{
		BScreen *screen = new BScreen();
		color_space depth = screen->ColorSpace();
		delete screen;
		
		/* Only makes sense for 8-bit matrix views */
		if (depth == B_COLOR_8_BIT)
		{
			/* Adjust for the bevel lines */
			where.x -= 3;
			where.y -= 3;

			/* Calculate the hit index */
			float size = CellSize();
			int32 column = where.x / size;
			int32 row = where.y / size;
			uint8 index = (row * Layout()) + column;
			
			/* Drag the color message... */
			rgb_color color = system_colors()->color_list[index];
			BMessage message = BMessage(B_SIMPLE_DATA);
			message.AddData("RGBColor", B_RGB_COLOR_TYPE, &color,
							 sizeof(rgb_color));
			BBitmap *bitmap = new BBitmap(BRect(0, 0, 10, 10), 
												B_COLOR_8_BIT);
			::memset(bitmap->Bits(), index, bitmap->BitsLength());
			DragMessage(&message, bitmap, BPoint(5, 5));
		}
		else
			BColorControl::MouseDown(where);
	}
	else
		BColorControl::MouseDown(where);
}


/* ...............................................................
	ColorPicker::SetValueQuietly()
	Sets the current value without updating the target.
   ............................................................... */

void ColorPicker::SetValueQuietly(rgb_color color)
{
	int32 c = (color.red << 24) + 
			  (color.green << 16) + 
			  (color.blue << 8);
	BColorControl::SetValue(c);
}


/* ...............................................................
	ColorPicker::SetValue()
	Overridden to "live" set the color of the focused ColorLabel
	whenever our value changes.
   ............................................................... */

void ColorPicker::SetValue(int32 value)
{
	BColorControl::SetValue(value);
	if ((Window() != NULL) && Window()->CurrentFocus() != NULL)
	{
		((ColorLabel *)(Window()->CurrentFocus()))->
			SetColor(ValueAsColor(), true);
	}
}